#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Data.SqlClient;

#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_StoredProcedure : BaseTest 
	{ 
		private const string HCPCS_CODES_LOOKUP_RPC_NAME = "VBECS HCPCS CODES LOOKUP";

		private DataTable _dtCannedComment;
		private System.Guid _commentGuid;
		private byte[] _rowVersion;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			//**Using CannedComment, cuz it's the simplest table, makes these tests faster to code
			if (this.RefreshData)
			{
				this._dtCannedComment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this._commentGuid = (System.Guid)this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentGuid];
				this._rowVersion = (byte[])this._dtCannedComment.Rows[0][TABLES.CannedComment.RowVersion];

				this.RefreshData = false;
			}
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			Common.StoredProcedure objTest = new Common.StoredProcedure();

			Assert.IsNotNull(objTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_ConnectionType_Pass()
		{
			Common.StoredProcedure objTest = new Common.StoredProcedure(Common.ConnectionType.VBECS);
			Assert.IsNotNull(objTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_ConnectionType_Fail()
		{
		}

		//TODO: check for _tempDataTable = null in ExecuteAction can be removed, DataTable casting on previous line
		//would error if the value was null - unreachable code
		[Test]
		public void GetDataTable_Pass()
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			DataTable dtTest = Common.StoredProcedure.GetDataTable(SPROCS.GetCannedComment.StoredProcName, parms);
            
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(this._commentGuid, (System.Guid)dtTest.Rows[0][TABLES.CannedComment.CannedCommentGuid], "Guid");
        }

		[Test]
		public void GetDataTable_Fail()
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			try
			{
				Common.StoredProcedure.GetDataTable(null, parms);
				Assert.AreEqual("Expected ArgumentNullException", false);
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				Common.StoredProcedure.GetDataTable(SPROCS.GetCannedComment.StoredProcName, null);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetSingleDataRow_Pass()
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			DataRow drTest = Common.StoredProcedure.GetSingleDataRow(SPROCS.GetCannedComment.StoredProcName, parms);
            
			Assert.AreEqual(this._commentGuid, (System.Guid)drTest[TABLES.CannedComment.CannedCommentGuid]);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetSingleDataRow_Fail()
		{
			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = System.Guid.NewGuid();
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			Common.StoredProcedure.GetSingleDataRow(SPROCS.GetCannedComment.StoredProcName, parms);
		}

		[Test]
		public void GetData_String_Parms_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentGuid];

			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			DataSet dsTest = Common.StoredProcedure.GetData(SPROCS.GetCannedComment.StoredProcName, parms);
            
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(1, dsTest.Tables[0].Rows.Count, "Rows.Count");
			Assert.AreEqual(this._commentGuid, (System.Guid)dsTest.Tables[0].Rows[0][TABLES.CannedComment.CannedCommentGuid], "Guid");
		}

		[Test]
		public void GetData_String_Parms_Fail()
		{
			System.Guid unitGuid = (System.Guid)this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentGuid];

			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			try
			{
				Common.StoredProcedure.GetData(null, parms);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				Common.StoredProcedure.GetData(SPROCS.GetCannedComment.StoredProcName, null);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetData_String_Pass()
		{
			DataSet dsTest = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetAllVbecsUsers.StoredProcName);
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetData_String_Fail()
		{
			Common.StoredProcedure.GetData(null);
		}
		[Test]
		public void GetData_String_ConnectionType_Parms_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentGuid];

			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			DataSet dsTest = Common.StoredProcedure.GetData(SPROCS.GetCannedComment.StoredProcName, Common.ConnectionType.VBECS, parms);
            
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(1, dsTest.Tables[0].Rows.Count, "Rows.Count");
			Assert.AreEqual(this._commentGuid, (System.Guid)dsTest.Tables[0].Rows[0][TABLES.CannedComment.CannedCommentGuid], "Guid");
		}

		[Test]
		public void GetData_String_ConnectionType_Parms_Fail()
		{
			System.Guid unitGuid = (System.Guid)this._dtCannedComment.Rows[0][TABLES.CannedComment.CannedCommentGuid];

			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.GetCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.GetCannedComment.divisioncode, SqlDbType.VarChar)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = UnitTestConfig.TestDivisionCode;

			try
			{
				Common.StoredProcedure.GetData(null, Common.ConnectionType.VBECS, parms);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				Common.StoredProcedure.GetData(SPROCS.GetCannedComment.StoredProcName, Common.ConnectionType.VBECS, null);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void TransactionalGetValue_IEnumerable_IEnumerable_Pass()
		{
			this.RefreshData = true;

			System.Collections.ArrayList sprocNames = new System.Collections.ArrayList();
			System.Collections.ArrayList dataTables = new System.Collections.ArrayList();

			DataTable dtUpdate = SprocHelper.GetUpdateCannedCommentSprocTable(this._commentGuid, this._rowVersion);

			sprocNames.Add(SPROCS.UpdateCannedComment.StoredProcName);
			dataTables.Add(dtUpdate);

			int retValue = new Common.StoredProcedure().TransactionalGetValue(sprocNames, dataTables);
			Assert.AreEqual(0, retValue, "ReturnValue");

			//Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE CannedCommentGuid = '" + this._commentGuid.ToString() + "'", true);
			byte[] newRowVersion = (byte[])dtTemp.Rows[0][TABLES.CannedComment.RowVersion];
			
			Assert.IsTrue(this._rowVersion != newRowVersion, "RowVersion");
		}

		[Test]
		public void TransactionalGetValue_IEnumerable_IEnumerable_Fail()
		{
			System.Collections.ArrayList arrayNull = null;
			System.Collections.ArrayList arrayTest = new System.Collections.ArrayList();

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(arrayNull, arrayTest);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(arrayTest, arrayNull);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void SimpleTransactionalGetValue_String_Pass()
		{
			int rc = new Common.StoredProcedure().SimpleTransactionalGetValue("batchspRunMarkUnitsPresumedTransfused");
			Assert.AreEqual(0, rc, "ReturnCode");
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void SimpleTransactionalGetValue_String_Fail()
		{
			new Common.StoredProcedure().SimpleTransactionalGetValue(null);
		}


		[Test]
		public void SimpleTransactionalGetValue_String_DataTable_Pass()
		{
			// Clear existing cache, if any
			UnitTestUtil.RunSQL("DELETE FROM dbo.HcpcsCache");
			//
			DateTime timeStart = DateTime.UtcNow;
			//
			DataTable hcpcsCodesTable = new DataTable();
			//
			hcpcsCodesTable.Columns.Add("Code", typeof(string));
			hcpcsCodesTable.Columns.Add("Name", typeof(string));
			//
			DataRow hcpcsCodesRow = hcpcsCodesTable.NewRow();
			hcpcsCodesRow["Code"] = "P9017";
			hcpcsCodesRow["Name"] = "PLASMA 1 DONOR FRZ W/IN 8 HR";
			hcpcsCodesTable.Rows.Add(hcpcsCodesRow);
			//
            int retValue = new Common.StoredProcedure().SimpleTransactionalGetValue(SPROCS.InsertHcpcsCache.StoredProcName, hcpcsCodesTable);
			Assert.AreEqual(0, retValue, "ReturnValue");

			// Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM HcpcsCache ORDER BY LastUpdateDate DESC", true);
			string code = dtTemp.Rows[0]["HcpcsCode"].ToString();
			//
			Assert.IsTrue(code.Equals("P9017"));
		}

		[Test]
		public void SimpleTransactionalGetValue_String_DataTable_Fail()
		{
			DataTable dtNull = null;

			try
			{
				new Common.StoredProcedure().SimpleTransactionalGetValue(null, new DataTable());
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				new Common.StoredProcedure().SimpleTransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, dtNull);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void SimpleTransactionalGetValue_IEnumerable_IEnumerable_Pass()
		{
			DateTime timeStart = DateTime.UtcNow;
			//
			ArrayList storedProcedures = new ArrayList();
			ArrayList dataTables = new ArrayList();
			//
			DataTable hcpcsCodesTable = new DataTable();
			//
			hcpcsCodesTable.Columns.Add("Code", typeof(string));
			hcpcsCodesTable.Columns.Add("Name", typeof(string));
			//
			DataRow hcpcsCodesRow = hcpcsCodesTable.NewRow();
			hcpcsCodesRow["Code"] = "P2028";
			hcpcsCodesRow["Name"] = "Cephalin floculation test";
			hcpcsCodesTable.Rows.Add(hcpcsCodesRow);
			//
			// Clear existing cache so we can insert the lastest from VistA
			storedProcedures.Add(SPROCS.ClearHcpcsCache.StoredProcName);
			dataTables.Add(new DataTable());
			//
			storedProcedures.Add(SPROCS.InsertHcpcsCache.StoredProcName);
			dataTables.Add(hcpcsCodesTable);
			//
            int retValue = new Common.StoredProcedure().SimpleTransactionalGetValue(storedProcedures, dataTables);
			Assert.AreEqual(0, retValue, "ReturnValue");

			// Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM HcpcsCache ORDER BY LastUpdateDate DESC", true);
			string code = dtTemp.Rows[0]["HcpcsCode"].ToString();
			//
			Assert.IsTrue(code.Equals("P2028"));
		}

		[Test]
		public void SimpleTransactionalGetValue_IEnumerable_IEnumerable_Fail()
		{
			System.Collections.ArrayList arrayNull = null;
			System.Collections.ArrayList arrayTest = new System.Collections.ArrayList();

			try
			{
				new Common.StoredProcedure().SimpleTransactionalGetValue(arrayNull, arrayTest);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(arrayTest, arrayNull);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void TransactionalGetValue_String_DataTable_Pass()
		{
			this.RefreshData = true;

			DataTable dtUpdate = SprocHelper.GetUpdateCannedCommentSprocTable(this._commentGuid, this._rowVersion);


			int retValue = new Common.StoredProcedure().TransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, dtUpdate);
			Assert.AreEqual(0, retValue, "ReturnValue");

			//Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE CannedCommentGuid = '" + this._commentGuid.ToString() + "'", true);
			byte[] newRowVersion = (byte[])dtTemp.Rows[0][TABLES.CannedComment.RowVersion];
			
			Assert.IsTrue(this._rowVersion != newRowVersion, "RowVersion");
		}

		[Test]
		public void TransactionalGetValue_String_DataTable_Fail()
		{
			DataTable dtNull = null;

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(null, new DataTable());
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, dtNull);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void TransactionalGetValue_String_DataRow_Pass()
		{
			this.RefreshData = true;

			DataTable dtUpdate = SprocHelper.GetUpdateCannedCommentSprocTable(this._commentGuid, this._rowVersion);

			int retValue = new Common.StoredProcedure().TransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, dtUpdate.Rows[0]);
			Assert.AreEqual(0, retValue, "ReturnValue");

			//Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE CannedCommentGuid = '" + this._commentGuid.ToString() + "'", true);
			byte[] newRowVersion = (byte[])dtTemp.Rows[0][TABLES.CannedComment.RowVersion];
			
			Assert.IsTrue(this._rowVersion != newRowVersion, "RowVersion");
		}

		[Test]
		public void TransactionalGetValue_String_DataRow_Fail()
		{
			DataRow drNull = null;

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(null, this._dtCannedComment.NewRow());
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, drNull);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void TransactionalGetValue_String_Params_Pass()
		{
			this.RefreshData = true;

			SqlParameter[] parms = 
				{
					new SqlParameter(SPROCS.UpdateCannedComment.cannedcommentguid, SqlDbType.UniqueIdentifier),
					new SqlParameter(SPROCS.UpdateCannedComment.sortcolumn, SqlDbType.Int),
					new SqlParameter(SPROCS.UpdateCannedComment.recordstatuscode, SqlDbType.Char),
					new SqlParameter(SPROCS.UpdateCannedComment.lastupdateuser, SqlDbType.VarChar),
					new SqlParameter(SPROCS.UpdateCannedComment.rowversion, SqlDbType.Timestamp),
					new SqlParameter(SPROCS.UpdateCannedComment.lastupdatefunctionid, SqlDbType.Int)
				};

			parms[0].Value = this._commentGuid;
			parms[1].Value = System.Convert.ToInt16(this._dtCannedComment.Rows[0][TABLES.CannedComment.SortColumn]);
			parms[2].Value = this._dtCannedComment.Rows[0][TABLES.CannedComment.RecordStatusCode].ToString();
			parms[3].Value = Common.LogonUser.LogonUserName;
			parms[4].Value = this._rowVersion;
			parms[5].Value = (int)Common.UpdateFunction.UnitTests;

			int retValue = new Common.StoredProcedure().TransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, parms);
			Assert.AreEqual(0, retValue, "ReturnValue");

			//Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE CannedCommentGuid = '" + this._commentGuid.ToString() + "'", true);
			byte[] newRowVersion = (byte[])dtTemp.Rows[0][TABLES.CannedComment.RowVersion];
			
			Assert.IsTrue(this._rowVersion != newRowVersion, "RowVersion");
		}

		[Test]
		public void TransactionalGetValue_String_Params_Fail()
		{
			SqlParameter[] parmsNull = null;

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(null, new SqlParameter[]{});
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				new Common.StoredProcedure().TransactionalGetValue(SPROCS.UpdateCannedComment.StoredProcName, parmsNull);
				Assert.IsTrue(false, "Expected ArgumentNullException");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void MakeLastUpdateUserSqlParam_Pass()
		{
			SqlParameter parmTest = Common.StoredProcedure.MakeLastUpdateUserSqlParam();

			Assert.AreEqual("@LastUpdateUser", parmTest.ParameterName, "LastUpdateName");
			Assert.AreEqual(DbType.String,  parmTest.DbType, "DbType");
			Assert.AreEqual(Common.LogonUser.LogonUserName, parmTest.Value.ToString(), "UserName");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MakeLastUpdateUserSqlParam_Fail()
		{
		}

		[Test]
		public void MakeParameter_Pass()
		{
			string testName = "UnitTestParameter";
			System.DateTime testValue = System.DateTime.Now;

			SqlParameter parmTest = Common.StoredProcedure.MakeParameter(testName, testValue);

			Assert.AreEqual(testName, parmTest.ParameterName, "Name");
			Assert.AreEqual(testValue.ToString(), parmTest.Value.ToString(), "Value");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MakeParameter_Fail()
		{
		}
	}
}

#endif
